bl_info = {
    "name": "Cranium",
    "author": "CG Groovy",
    "version": (0, 9),
    "blender": (2, 80, 0),
    "location": "View3D > Add > Mesh > Cranium",
    "description": "Add a head primitive, ready for the sculpting to human faces",
    "warning": "",
    "wiki_url": "https://www.youtube.com/watch?v=fg9fNUTb0uo",
    "category": "Add Mesh",
}


import bpy
from bpy.types import Operator
from bpy_extras.object_utils import AddObjectHelper, object_data_add
from mathutils import Vector


def add_object(self, context):

    verts = [
        Vector((0, -0.83986 , -0.75808)),
        Vector((0.12799,-0.81130,-0.77167)),
        Vector((0.26875,-0.71126,-0.75137)),
        Vector((0.36180,-0.61165,-0.70388)),
        Vector((0.43566,-0.51333,-0.63712)),
        Vector((0.48091,-0.44039,-0.49987)),
        Vector((0.51052,-0.40457,-0.36770)),
        Vector((0.54606,-0.33927,-0.23829)),
        Vector((0.58623,-0.25800,-0.03618)),
        Vector((0.61421,-0.29111,0.19958)),
        Vector((0.52036,-0.42328,0.55059)),
        
        Vector((0.26667,-0.52520,0.72628)),
        Vector((0,-0.57055,0.73711)),
        Vector((-0.26667,-0.52520,0.72628)),
        Vector((-0.52036,-0.42328,0.55059)),
        Vector((-0.61421,-0.29111,0.19958)),
        Vector((-0.58623,-0.25800,-0.03618)),
        Vector((-0.54606,-0.33927,-0.23829)),
        Vector((-0.51052,-0.40457,-0.36770)),
        Vector((-0.48091,-0.44039,-0.49987)),
        Vector((-0.43566,-0.51333,-0.63712)),
        
        Vector((-0.36180,-0.61165,-0.70388)),
        Vector((-0.26875,-0.71126,-0.75137)),
        Vector((-0.12799,-0.81130,-0.77167)),
        Vector((0,-0.83988,-0.56545)),
        Vector((0.11946,-0.81538,-0.56417)),
        Vector((0.23881,-0.75884,-0.56184)),
        Vector((0.34135,-0.66613,-0.54984)),
        Vector((0.39722,-0.59355,-0.53974)),
        Vector((0.45311,-0.52733,-0.45173)),
        Vector((0.47077,-0.50955,-0.32727)),
        
        Vector((0.50605,-0.46007,-0.19937)),
        Vector((0.54879,-0.41001,-0.04774)),
        Vector((0.57465,-0.47388, 0.14494)),
        Vector((0.43747,-0.64004, 0.36516)),
        Vector((0.21163,-0.74920, 0.40369)),
        Vector((0,-0.79446, 0.39695)),
        Vector((-0.21163,-0.74920,0.40369)),
        Vector((-0.43747,-0.64004,0.36516)),
        Vector((-0.57465,-0.47388,0.14494)),
        Vector((-0.54879,-0.41001,-0.04774)),
        
        Vector((-0.50605,-0.46007,-0.19937)),
        Vector((-0.47077,-0.50955,-0.32727)),
        Vector((-0.45311,-0.52733,-0.45173)),
        Vector((-0.39722,-0.59355,-0.53974)),
        Vector((-0.34135,-0.66613,-0.54984)),
        Vector((-0.23881,-0.75884,-0.56184)),
        Vector((-0.11946,-0.81538,-0.56417)),
        Vector((0,-0.83592,-0.44781)),
        Vector((0.11259,-0.82550,-0.44549)),
        Vector((0.23230,-0.77296,-0.43175)),
        
        Vector((0.32581,-0.70920,-0.43116)),
        Vector((0.41502,-0.61644,-0.36604)),
        Vector((0.43755,-0.58640,-0.27431)),
        Vector((0.45346,-0.55509,-0.15297)),
        Vector((0.51346,-0.50891,-0.03780)),
        Vector((0.53239,-0.58745,0.09185)),
        Vector((0.41738,-0.73542,0.22092)),
        Vector((0.20901,-0.83886,0.24714)),
        Vector((0,-0.89396,0.23798)),
        Vector((-0.20901,-0.83886,0.24714)),
        
        Vector((-0.41738,-0.73542,0.22092)),
        Vector((-0.53239,-0.58745,0.09185)),
        Vector((-0.51346,-0.50891,-0.03780)),
        Vector((-0.45346,-0.55509,-0.15297)),
        Vector((-0.43755,-0.58640,-0.27431)),
        Vector((-0.41502,-0.61644,-0.36604)),
        Vector((-0.39547,-0.63966,-0.42880)),
        Vector((-0.32581,-0.70920,-0.43116)),
        Vector((-0.23230,-0.77296,-0.43175)),
        Vector((-0.11259,-0.82550,-0.44549)),
        
        Vector((0,-0.81599,-0.30169)),
        Vector((0.07605,-0.81416,-0.30042)),
        Vector((0.16396,-0.78223,-0.30564)),
        Vector((0.32018,-0.70295,-0.32221)),
        Vector((0.34333,-0.66250,-0.22095)),
        Vector((0.32460,-0.62605,-0.12318)),
        Vector((0.41926,-0.57617,-0.03521)),
        Vector((0.44168,-0.59898,0.05485)),
        Vector((0.36865,-0.67349,0.13155)),
        Vector((0.17718,-0.79170,0.15283)),
        
        Vector((0,-0.85048,0.14886)),
        Vector((-0.17718,-0.79170,0.15283)),
        Vector((-0.36865,-0.67349,0.13155)),
        Vector((-0.44168,-0.59898,0.05485)),
        Vector((-0.41926,-0.57617,-0.03521)),
        Vector((-0.32460,-0.62605,-0.12318)),
        Vector((-0.34333,-0.66250,-0.22095)),
        Vector((-0.32018,-0.70295,-0.32221)),
        Vector((-0.16396,-0.78223,-0.30564)),
        Vector((-0.07605,-0.81416,-0.30042)),
        
        Vector((0,-0.80786,-0.25668)),
        Vector((0.07371,-0.80585,-0.25443)),
        Vector((0.12564,-0.78313,-0.26035)),
        Vector((0.12886,-0.77718,-0.20657)),
        Vector((0.05610,-0.77215,-0.13545)),
        Vector((0,-0.77535,-0.12567)),
        Vector((-0.05610,-0.77215,-0.13545)),
        Vector((-0.12886,-0.77718,-0.20657)),
        Vector((-0.12564,-0.78313,-0.26035)),
        Vector((-0.07371,-0.80585,-0.25443)),
        
        Vector((0.19044,-0.76078,-0.20673)),
        Vector((0.05458,-0.76525,-0.07229)),
        Vector((0,-0.76793,-0.06181)),
        Vector((-0.05458,-0.76525,-0.07229)),
        Vector((-0.19044,-0.76078,-0.20673)),
        Vector((-0.18391,-0.72099,-0.11214)),
        Vector((-0.05821,-0.75281,0.00575)),
        Vector((-0.06961,-0.77167,0.08682)),
        Vector((-0.12356,-0.69734,0.06090)),
        Vector((-0.20289,-0.67278,0.11484)),
        
        Vector((-0.29517,-0.62222,0.10282)),
        Vector((-0.35715,-0.56934,0.03046)),
        Vector((-0.34332,-0.55691,-0.03575)),
        Vector((-0.27775,-0.57601,-0.08440)),
        Vector((-0.18371,-0.62689,-0.07437)),
        Vector((-0.12015,-0.67920,-0.00667)),
        Vector((-0.20943,-0.57021,0.02530)),
        Vector((0.05821,-0.75281,0.00575)),
        Vector((0.06961,-0.77167,0.08682)),
        Vector((0.12356,-0.69734,0.06090)),
        
        Vector((0.20289,-0.67278,0.11484)),
        Vector((0.29517,-0.62222,0.10282)),
        Vector((0.35715,-0.56934,0.03046)),
        Vector((0.34332,-0.55691,-0.03575)),
        Vector((0.27775,-0.57601,-0.08440)),
        Vector((0.18371,-0.62689,-0.07437)),
        Vector((0.12015,-0.67920,-0.00667)),
        Vector((0.20943,-0.57021,0.02530)),
        Vector((0.18391,-0.72099,-0.11214)),
        Vector((0,-0.78137,0.00810)),
        
        Vector((0,-0.81514,0.08544)),
        Vector((-0.10388,-0.84214,-0.87844)),
        Vector((0,-0.86426,-0.88212)),
        Vector((0.10388,-0.84214,-0.87844)),
        Vector((0.13774,-0.78818,-0.98391)),
        Vector((0.20639,-0.72891,-0.95389)),
        Vector((0.29165,-0.63874,-0.90823)),
        Vector((0.35411,-0.51161,-0.81274)),
        Vector((0.43264,-0.39698,-0.71299)),
        Vector((0.46568,-0.33755,-0.55396)),
        
        Vector((0.49462,-0.29338,-0.41889)),
        Vector((0.54234,-0.20114,-0.28524)),
        Vector((0.58865,-0.11058,-0.10346)),
        Vector((0.64951,-0.07649,0.28974)),
        Vector((0.57990,-0.14785,0.62613)),
        Vector((0.37326,-0.16608,0.88388)),
        Vector((0,-0.14843,0.97611)),
        Vector((-0.37326,-0.16608,0.88388)),
        Vector((-0.57990, -0.14785,0.62613)),
        Vector((-0.64951,-0.07649,0.28974)),
        
        Vector((-0.58865,-0.11058,-0.10346)),
        Vector((-0.54234,-0.20114,-0.28524)),
        Vector((-0.49462,-0.29338,-0.41889)),
        Vector((-0.46568,-0.33755,-0.55396)),
        Vector((-0.43264,-0.39698,-0.71299)),
        Vector((-0.35411,-0.51161,-0.81274)),
        Vector((-0.29165,-0.63874,-0.90823)),
        Vector((-0.20639,-0.72891,-0.95389)),
        Vector((-0.13774,-0.78818,-0.98391)),
        Vector((0,-0.81737,-0.99870)),
        
        Vector((0,-0.71818,-0.94835)),
        Vector((0,-0.60722,-0.89136)),
        Vector((0,-0.49455,-0.83349)),
        Vector((0,-0.30637,-0.73685)),
        Vector((-0.12814,-0.29574,-0.73288)),
        Vector((-0.25608,-0.31006,-0.72605)),
        Vector((-0.34478,-0.34504,-0.72559)),
        Vector((-0.29541,-0.41973,-0.78258)),
        Vector((-0.18886,-0.49676,-0.83321)),
        Vector((-0.16889,-0.61264,-0.89413)),
        
        Vector((-0.10911,-0.70572,-0.94195)),
        Vector((0.10911,-0.70572,-0.94195)),
        Vector((0.16889,-0.61264,-0.89413)),
        Vector((0.18886,-0.49676,-0.83321)),
        Vector((0.29541,-0.41973,-0.78258)),
        Vector((0.34478,-0.34504,-0.72559)),
        Vector((0.25608,-0.31006,-0.72605)),
        Vector((0.12814,-0.29574,-0.73288)),
        Vector((0.13992,-0.21456,-0.55976)),
        Vector((0.27513,-0.22987,-0.55005)),
        
        Vector((0.38446,-0.27587,-0.54446)),
        Vector((0.41290,-0.18409,-0.42884)),
        Vector((0.30946,-0.10298,-0.43850)),
        Vector((0.15802,-0.07256,-0.45167)),
        Vector((0,-0.06415,-0.45495)),
        Vector((0,-0.21056,-0.56292)),
        Vector((-0.13992,-0.21456,-0.55976)),
        Vector((-0.15802,-0.07256,-0.45167)),
        Vector((-0.30946,-0.10298,-0.43850)),
        Vector((-0.27513,-0.22987,-0.55005)),
        
        Vector((-0.38446,-0.27587,-0.54446)),
        Vector((-0.41290,-0.18409,-0.42884)),
        Vector((-0.46712,-0.05455,-0.33320)),
        Vector((-0.39255,0.10698,-0.35339)),
        Vector((-0.18273,0.12883,-0.38413)),
        Vector((0,0.13466,-0.38394)),
        Vector((0.18273,0.12883,-0.38413)),
        Vector((0.39255,0.10698,-0.35339)),
        Vector((0.46712,-0.05455,-0.33320)),
        Vector((0.56095,0.01722,-0.22396)),
        
        Vector((0.53495,0.18571,-0.23142)),
        Vector((0.56302,0.41535,-0.19843)),
        Vector((0.58399,0.56026,-0.10247)),
        Vector((0.59400,0.61014,0.08492)),
        Vector((0.60350,0.60160,0.29808)),
        Vector((0.64465,0.41265,0.41774)),
        Vector((0.66144,0.20134,0.43654)),
        Vector((0.67655,0.22434,0.23065)),
        Vector((0.67470,0.06859,0.16881)),
        Vector((0.63688,0.06965,0.00482)),
        
        Vector((0.59798,0.12178,-0.10389)),
        Vector((0.61538,0.22686,-0.09618)),
        Vector((0.62181,0.36199,-0.05873)),
        Vector((0.62443,0.46352,-0.02211)),
        Vector((0.64435,0.48151,0.08782)),
        Vector((0.65502,0.47718,0.20984)),
        Vector((0.66838,0.36718,0.24497)),
        Vector((0.65498,0.35860,0.08376)),
        Vector((0.65908,0.22283,0.05804)),
        Vector((0.59292,0.15758,0.69473)),
        
        Vector((0.38247,0.19834,0.92683)),
        Vector((0,0.23203,0.99688)),
        Vector((-0.38247,0.19834,0.92683)),
        Vector((-0.59292,0.15758,0.69473)),
        Vector((-0.66144,0.20134,0.43654)),
        Vector((-0.64465,0.41265,0.41774)),
        Vector((-0.60350,0.60160,0.29808)),
        Vector((-0.59400,0.61014,0.08492)),
        Vector((-0.58399,0.56026,-0.10247)),
        Vector((-0.56302,0.41535,-0.19843)),
        
        Vector((-0.53495,0.18571,-0.23142)),
        Vector((-0.56095,0.01722,-0.22396)),
        Vector((-0.59798,0.12178,-0.10389)),
        Vector((-0.63688,0.06965,0.00482)),
        Vector((-0.67470,0.06859,0.16881)),
        Vector((-0.67655,0.22434,0.23065)),
        Vector((-0.66838,0.36718,0.24497)),
        Vector((-0.65502,0.47718,0.20984)),
        Vector((-0.64435,0.48151,0.08782)),
        Vector((-0.62443,0.46352,-0.02211)),
        
        Vector((-0.62181,0.36199,-0.05873)),
        Vector((-0.65498,0.35860,0.08376)),
        Vector((-0.65908,0.22283,0.05804)),
        Vector((-0.61538,0.22686,-0.09618)),
        Vector((-0.44786,0.45804,-0.30073)),
        Vector((-0.24087,0.46128,-0.35591)),
        Vector((0,0.46240,-0.35496)),
        Vector((0.24087,0.46128,-0.35591)),
        Vector((0.44786,0.45804,-0.30073)),
        Vector((0.47948,0.66859,-0.16581)),
        
        Vector((0.29318,0.74613,-0.21508)),
        Vector((0,0.75939,-0.22757)),
        Vector((-0.29318,0.74613,-0.21508)),
        Vector((-0.47948,0.66859,-0.16581)),
        Vector((-0.51916,0.77039,0.07127)),
        Vector((-0.34687,0.88109,0.05552)),
        Vector((0,0.95472,0.03986)),
        Vector((0.34687,0.88109,0.05552)),
        Vector((0.51916,0.77039,0.07127)),
        Vector((0.51220,0.72533,0.43447)),
        
        Vector((0.32712,0.84597,0.49753)),
        Vector((0,0.92430,0.49701)),
        Vector((-0.32712,0.84597,0.49753)),
        Vector((-0.51220,0.72533,0.43447)),
        Vector((-0.55744,0.53269,0.63651)),
        Vector((-0.33452,0.60074,0.81214)),
        Vector((0,0.63643,0.83668)),
        Vector((0.33452,0.60074,0.81214)),
        Vector((0.55744,0.53269,0.63651)),
        Vector((0.39547,-0.63966,-0.42880)),]

    edges = []
    faces = [[1,2,26,25],[25,26,50,49],[49,50,73,72],[2,3,27,26],[26,27,51,50],[50,51,74,73],
    [23,47,46,22],[47,70,69,46],[70,90,89,69],[22,46,45,21],[46,69,68,45],[69,89,88,68],[23,0,24,47],
    [70,47,24,48],[90,70,48,71],[24,0,1,25],[48,24,25,49],[71,48,49,72],
    [98,99,100,97],[97,100,91,96],[96,91,92,95],[95,92,93,94],[74,51,270,52],[270,51,27,28],[27,3,4,28],
    [52,270,28,29],[29,28,4,5],[67,68,88,66],[44,45,68,67],[20,21,45,44],[43,44,67,66],[19,20,44,43],
    [100,99,89,90],[91,100,90,71],[92,91,71,72],[93,92,72,73],[101,94,93,73],[89,99,98,105],[104,97,96,103],[102,103,96,95],
    [95,94,101,102],[105,98,97,104],[87,88,89,105],[65,66,88,87],[42,43,66,65],[18,19,43,42],[101,73,74,75],[75,74,52,53],
    [53,52,29,30],[30,29,5,6],[128,126,125],[128,127,126],[128,120,127],[128,121,120],[128,122,121],[128,125,124],[128,124,123],[128,123,122],
    [117,114,115],[117,115,116],[117,116,109],[117,109,110],[117,110,111],[117,111,112],[117,112,113],[117,113,114],[125,126,129,76],[124,125,76,77],[123,124,77,78],[79,122,123,78],[80,121,122,79],
    [120,121,80,119],[127,120,119,118],[129,126,127,118],[116,107,108,109],[82,110,109,108],[83,111,110,82],[84,112,111,83],[85,113,112,84],[86,114,113,85],[106,115,114,86],[107,116,115,106],[131,108,107,130],
    [131,130,118,119],[82,108,131,81],[81,131,119,80],[6,7,31,30],[7,8,32,31],[8,9,33,32],[9,10,34,33],[10,11,35,34],[11,12,36,35],[12,13,37,36],[13,14,38,37],[14,15,39,38],[15,16,40,39],[16,17,41,40],[41,17,18,42],
    [76,54,55,77],[77,55,56,78],[78,56,57,79],[79,57,58,80],[80,58,59,81],[81,59,60,82],[82,60,61,83],[83,61,62,84],[84,62,63,85],[85,63,64,86],[64,65,87,86],[86,87,105,106],[106,105,104,107],[107,104,103,130],[130,103,102,118],
    [118,102,101,129],[129,101,75,76],[76,75,53,54],[31,54,53,30],[32,55,54,31],[33,56,55,32],[34,57,56,33],[35,58,57,34],[36,59,58,35],[37,60,59,36],[38,61,60,37],[39,62,61,38],[40,63,62,39],[41,64,63,40],[42,65,64,41],[133,160,135,134],
    [159,160,133,132],[0,133,134,1],[23,132,133,0],[135,136,1,134],[23,158,159,132],[136,137,2,1],[137,138,3,2],[138,139,4,3],[139,140,5,4],[140,141,6,5],[141,142,7,6],[142,143,8,7],[143,144,9,8],[144,145,10,9],[145,146,11,10],[146,147,12,11],
    [147,148,13,12 ],[148,149,14,13],[149,150,15,14],[150,151,16,15],[151,152,17,16],[152,153,18,17],[153,154,19,18],[154,155,20,19],[155,156,21,20],[156,157,22,21],[157,158,23,22],[143,210,209,144],[209,208,207,144],[207,220,145,144],
    [143,200,211,210],[140,181,182,141],[142,199,200,143],[182,199,142,141],[220,221,146,145],[221,222,147,146],[211,212,219,210],[219,208,209,210],[212,213,218,219],[213,214,215,218],[215,216,217,218],[217,208,219,218],[150,235,234,151],
    [150,225,236,235],[225,226,237,236],[226,227,238,237],[227,228,239,238],[228,229,240,239],[229,230,241,240],[230,231,244,241],[231,232,233,244],[232,151,234,233],[239,240,241,242],[242,241,244,243],[243,244,233,234],[237,238,239,242],[236,237,242,243],
    [243,234,235,236],[149,224,225,150],[148,223,224,149],[222,223,148,147],[230,229,254,245],[245,254,253,246],[246,253,252,247],[247,252,251,248],[248,251,250,249],[249,250,203,202],[202,203,214,213],[202,213,212,201],[212,211,200,201],[201,200,199,198],[198,199,182,183],
    [198,183,184,197],[197,184,185,196],[196,185,188,195],[195,188,189,194],[194,189,192,193],[194,193,232,231],[232,193,152,151],[193,192,153,152],[245,194,231,230],[246,195,194,245],[247,196,195,246],[248,197,196,247],[249,198,197,248],[202,201,198,249],
    [181,180,183,182],[180,179,184,183],[179,186,185,184],[186,187,188,185],[187,190,189,188],[190,191,192,189],[191,154,153,192],[139,176,181,140],[176,177,180,181],[177,178,179,180],[178,164,186,179],[164,165,187,186],[165,166,190,187],[166,167,191,190],
    [167,155,154,191],[175,177,176],[168,167,166],[168,156,155,167],[138,175,176,139],[175,174,178,177],[174,163,164,178],[163,169,165,164],[169,168,166,165],[137,174,175,138],[136,173,174,137],[135,172,173,136],[160,161,172,135],[159,171,161,160],[158,170,171,159],
    [157,169,170,158],[156,168,169,157],[173,162,163,174],[162,170,169,163],[161,162,173,172],[171,170,162,161],[203,204,215,214],[204,205,216,215],[205,206,217,216],[206,207,208,217],[227,264,255,228],[264,263,256,255],[263,262,257,256],[262,261,258,257],[261,260,259,258],
    [260,205,204,259],[255,254,229,228],[256,253,254,255],[257,252,253,256],[258,251,252,257],[259,250,251,258],[259,204,203,250],[224,265,226,225],[223,266,265,224],[265,264,227,226],[222,267,266,223],[221,268,267,222],[220,269,268,221],[206,269,220,207],[266,263,264,265],
    [267,262,263,266],[268,261,262,267],[269,260,261,268],[205,260,269,206]]
 
    mesh = bpy.data.meshes.new(name="Cranium")
    mesh.from_pydata(verts, edges, faces)
    # useful for development when the mesh may be invalid.
    # mesh.validate(verbose=True)
    object_data_add(context, mesh, operator=self)


class OBJECT_OT_add_object(Operator, AddObjectHelper):
    """Create a new primitive head"""
    bl_idname = "mesh.add_cranium"
    bl_label = "Add Cranium"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):

        add_object(self, context)

        return {'FINISHED'}


# Registration

def add_object_button(self, context):
    self.layout.operator(
        OBJECT_OT_add_object.bl_idname,
        text="Cranium",
        icon='MONKEY')


def register():
    bpy.utils.register_class(OBJECT_OT_add_object)
    bpy.types.VIEW3D_MT_mesh_add.append(add_object_button)


def unregister():
    bpy.utils.unregister_class(OBJECT_OT_add_object)
    bpy.types.VIEW3D_MT_mesh_add.remove(add_object_button)


if __name__ == "__main__":
    register()
